﻿using System.Configuration;
using System.Threading.Tasks;
using VA.PPMS.IWS.Functions.Configuration.Interface;

namespace VA.PPMS.IWS.Functions.Configuration
{
    public class IwsConfiguration : IIwsConfiguration
    {
        public IwsConfiguration()
        {
        }

        public async Task<string> GetBlobNameAsync()
        {
            return await GetConfigValue("BlobName");
        }

        public async Task<string> GetResponseQueueNameAsync()
        {
            return await GetConfigValue("PpmsCreateResponse_ResponseQueueName");
        }

        public async Task<string> GetConnectionAsync()
        {
            await Task.Run(() => {});
            return ConfigurationManager.ConnectionStrings["StorageConn"].ConnectionString;
        }

        public async Task<string> GetOrgClientIdAsync()
        {
            return await GetConfigValue("PpmsClientId");
        }

        public async Task<string> GetOrgClientSecretAsync()
        {
            return await GetConfigValue("PpmsClientSecret");
        }

        public async Task<string> GetOrgBaseAsync()
        {
            return await GetConfigValue("PpmsOrgBase");
        }
        
        public async Task<UrlPacket> GetCcnInitialDataRequestUrlAsync()
        {
            var host = await GetConfigValue("CcnInitialDataRequest_Host");
            var port = await GetConfigValue("CcnInitialDataRequest_Port");
            var pattern = await GetConfigValue("CcnInitialDataRequest_Pattern");

            return new UrlPacket { Host = host, Port = port, UrlPattern = pattern };
        }

        public async Task<string> GetResponseDocumentPathPatternAsync()
        {
            return await GetConfigValue("PpmsCreateResponse_DocumentUriPattern");
        }

        public async Task<string> GetResponseDocumentReferenceUrlAsync()
        {
            return await GetConfigValue("PpmsCreateResponse_DocRefUri");
        }

        public async Task<string> GetPpmsXrmServicesUriAsync()
        {
            return await GetConfigValue("PpmsXrmServicesUri");
        }

        public async Task<string> GetPpmsApiUriAsync()
        {
            return await GetConfigValue("PpmsApiUri");
        }

        public async Task<string> GetPpmsResponseNotificationUriAsync(bool isVaProvider = false)
        {
            if (isVaProvider)
                return await GetConfigValue("PpmsCreateResponse_PieNotificationUri");
            else
                return await GetConfigValue("PpmsCreateResponse_NotificationUri");
        }

        public async Task<string> GetPpmsResponsePostUriAsync(bool isVaProvider = false)
        {
            if (isVaProvider)
                return await GetConfigValue("PpmsCreateResponse_PiePostUri");
            else
                return await GetConfigValue("PpmsCreateResponse_PostUri");
        }

        public async Task<string> GetCcnDocRefQueueNameAsync()
        {
            return await GetConfigValue("CcnInitialDocRef_QueueName");
        }

        public async Task<SchemaProfile> GetSchemaProfileAsync(SchemaOptions.SchemaProfiles profile)
        {
            var schemaPrefix = "p"; // await GetConfigValue("Schema.Prefix");

            switch (profile)
            {
                case SchemaOptions.SchemaProfiles.CCN:
                    var schemaName1 = await GetConfigValue(SchemaOptions.CcnSchemaProfile);
                    var schemaNamspace1 = await GetConfigValue(SchemaOptions.CcnNamespaceProfile);
                    return new SchemaProfile { Prefix = schemaPrefix, Namespace = schemaNamspace1, SchemaName = schemaName1 };

                case SchemaOptions.SchemaProfiles.VA:
                    var schemaName2 = await GetConfigValue(SchemaOptions.VaSchemaProfile);
                    var schemaNamspace2 = await GetConfigValue(SchemaOptions.VaNamespaceProfile);
                    return new SchemaProfile { Prefix = schemaPrefix, Namespace = schemaNamspace2, SchemaName = schemaName2 };

                case SchemaOptions.SchemaProfiles.Response:
                    var schemaName3 = await GetConfigValue(SchemaOptions.ResponseSchemaProfile);
                    var schemaNamspace3 = await GetConfigValue(SchemaOptions.CcnNamespaceProfile);
                    return new SchemaProfile { Prefix = schemaPrefix, Namespace = schemaNamspace3, SchemaName = schemaName3 };

                default:
                    var schemaName4 = await GetConfigValue(SchemaOptions.GeneralSchemaProfile);
                    var schemaNamspace4 = await GetConfigValue(SchemaOptions.CcnNamespaceProfile);
                    return new SchemaProfile { Prefix = schemaPrefix, Namespace = schemaNamspace4, SchemaName = schemaName4 };
            }
        }

        public async Task<string> GetPpmsDasIdentifierAsync()
        {
            var id = await GetConfigValue("DAS.PpmsId");
            //TODO: Set proper value in config
            return "VA_PPMS";
        }

        public async Task<string> GetNpiStatusTableNameAsync()
        {
            return await GetConfigValue("NpiStatusTable");
        }

        public async Task<string> GetActivityHistoryTableNameAsync()
        {
            return await GetConfigValue("ActivityHistoryTable");
        }

        public async Task<string> GetProviderPayloadQueueAsync()
        {
            return await GetConfigValue("ProviderPayloadQueue");
        }

        public async Task<string> GetNppesTargetUri()
        {
            return await GetConfigValue("NppesTargetUri");
        }

        public async Task<string> GeTargetName(string target)
        {
            return await GetConfigValue(target);
        }

        private static async Task<string> GetConfigValue(string configKey)
        {
            await Task.Run(() => {});

            return ConfigurationManager.AppSettings[configKey];
        }

        public async Task<string> GetDasCertUrl()
        {
            return await GetConfigValue("DAS.CertUrl");
        }

        public async Task<string> GetDasAppId()
        {
            return await GetConfigValue("DAS.AppId");
        }

        public async Task<string> GetDasSecret()
        {
            return await GetConfigValue("DAS.Secret");
        }
    }
}